﻿<?LassoScript
/*
Demo illustrating how text and image objects can be rotated.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/


//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype, -nocompress));

var('image' = pdf_image(
	-file = 'ball.gif', -rotate = 75));

// Note that -width and -height sets the image dimensions without regards
// to the rotate setting.
// So the image wont fit within a box of 200 X 100. Take that into account
// when setting -top
$pdf -> add( $image,
	-height = 200,
	-width = 100,
	-left = 300,
	-top = 250
	);

// Place a rectangle to show the point at where the image is placed.
$pdf -> rect( 300, $pageheight - 250, 1, 1, -fill);



// Place some rotated text objects

var('text' = pdf_text( 'You can rotate text in whatever direction you want.'));

$pdf -> add( $text,
	-rotate = 90
	);

$pdf -> add( $text,
	-rotate = -20
	);

$pdf -> add( $text,
	-rotate = 190
	);

var('text' = pdf_text( 'But you can\'t rotate text and at the same time place it using add.'));

$pdf -> add( $text,
	-height = 70,
	-width = 200,
	-left = 320,
	-top = 400,
	-rotate = 20 // This won't work
	);

$pdf -> drawtext( 'Instead you have to use DrawText', 
	-left = 320,
	-top = 520,
	-rotate = 20 // This will work
	);

// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo5.pdf', -inline);

?>